package com.ejie.aa17a.control;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.aa17a.model.Aa17aBandaContaminante;
import com.ejie.aa17a.service.iface.Aa17aBandaContaminanteService;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;

/**
 * Aa17aBandaContaminanteController generated by UDA, 18-dic-2013 15:36:30.
 * 
 * @author UDA
 */

@RequestMapping(value = "/aa17abandacontaminante")
public class Aa17aBandaContaminanteController {

	private static final Logger logger = LoggerFactory.getLogger(Aa17aBandaContaminanteController.class);

	private Aa17aBandaContaminanteService aa17aBandaContaminanteService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		Aa17aBandaContaminanteController.logger.info("[GET - View] : aa17abandacontaminante");
		return "aa17abandacontaminante";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param idContaminante
	 *            Long
	 * @param idBanda
	 *            Long
	 * @param valorMinimo
	 *            BigDecimal
	 * @param valorMaximo
	 *            BigDecimal
	 * @return aa17aBandaContaminante Aa17aBandaContaminante
	 */
	@RequestMapping(value = "/{idContaminante}/{idBanda}/{valorMinimo}/{valorMaximo}", method = RequestMethod.GET)
	public @ResponseBody
	Aa17aBandaContaminante getById(@PathVariable Long idContaminante, @PathVariable Long idBanda, @PathVariable BigDecimal valorMinimo, @PathVariable BigDecimal valorMaximo) {
		Aa17aBandaContaminante aa17aBandaContaminante = new Aa17aBandaContaminante();
		aa17aBandaContaminante.setIdContaminante(idContaminante);
		aa17aBandaContaminante.setIdBanda(idBanda);
		aa17aBandaContaminante.setValorMinimo(valorMinimo);
		aa17aBandaContaminante.setValorMaximo(valorMaximo);
		aa17aBandaContaminante = this.aa17aBandaContaminanteService.find(aa17aBandaContaminante);
		Aa17aBandaContaminanteController.logger.info("[GET - findBy_PK] : Obtener Aa17aBandaContaminante por PK");
		return aa17aBandaContaminante;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterAa17aBandaContaminante
	 *            Aa17aBandaContaminante
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Aa17aBandaContaminante> getAll(@ModelAttribute Aa17aBandaContaminante filterAa17aBandaContaminante) {
		Aa17aBandaContaminanteController.logger.info("[GET - find_ALL] : Obtener Aa17aBandaContaminante por filtro");
		return this.aa17aBandaContaminanteService.findAll(filterAa17aBandaContaminante, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param aa17aBandaContaminante
	 *            Aa17aBandaContaminante
	 * @return Aa17aBandaContaminante
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Aa17aBandaContaminante edit(@RequestBody Aa17aBandaContaminante aa17aBandaContaminante) {
		Aa17aBandaContaminante aa17aBandaContaminanteAux = this.aa17aBandaContaminanteService.update(aa17aBandaContaminante);
		Aa17aBandaContaminanteController.logger.info("[PUT] : Aa17aBandaContaminante actualizado correctamente");
		return aa17aBandaContaminanteAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param aa17aBandaContaminante
	 *            Aa17aBandaContaminante
	 * @return Aa17aBandaContaminante
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Aa17aBandaContaminante add(@RequestBody Aa17aBandaContaminante aa17aBandaContaminante) {
		Aa17aBandaContaminante aa17aBandaContaminanteAux = this.aa17aBandaContaminanteService.add(aa17aBandaContaminante);
		Aa17aBandaContaminanteController.logger.info("[POST] : Aa17aBandaContaminante insertado correctamente");
		return aa17aBandaContaminanteAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param idContaminante
	 *            Long
	 * @param idBanda
	 *            Long
	 * @param valorMinimo
	 *            BigDecimal
	 * @param valorMaximo
	 *            BigDecimal
	 * @return aa17aBandaContaminante
	 */
	@RequestMapping(value = "/{idContaminante}/{idBanda}/{valorMinimo}/{valorMaximo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Aa17aBandaContaminante remove(@PathVariable Long idContaminante, @PathVariable Long idBanda, @PathVariable BigDecimal valorMinimo, @PathVariable BigDecimal valorMaximo) {
		Aa17aBandaContaminante aa17aBandaContaminante = new Aa17aBandaContaminante();
		aa17aBandaContaminante.setIdContaminante(idContaminante);
		aa17aBandaContaminante.setIdBanda(idBanda);
		aa17aBandaContaminante.setValorMinimo(valorMinimo);
		aa17aBandaContaminante.setValorMaximo(valorMaximo);
		this.aa17aBandaContaminanteService.remove(aa17aBandaContaminante);
		Aa17aBandaContaminanteController.logger.info("[DELETE] : Aa17aBandaContaminante borrado correctamente");
		return aa17aBandaContaminante;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param aa17aBandaContaminanteIds
	 *            List
	 * @return aa17aBandaContaminanteList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(@RequestBody List<List<String>> aa17aBandaContaminanteIds) {
		List<Aa17aBandaContaminante> aa17aBandaContaminanteList = new ArrayList<Aa17aBandaContaminante>();
		for (List<String> aa17aBandaContaminanteId : aa17aBandaContaminanteIds) {
			Iterator<String> iterator = aa17aBandaContaminanteId.iterator();
			Aa17aBandaContaminante aa17aBandaContaminante = new Aa17aBandaContaminante(); //NOPMD - Objeto nuevo en la lista (parametro del servicio)
			aa17aBandaContaminante.setIdContaminante(ObjectConversionManager.convert(iterator.next(), Long.class));
			aa17aBandaContaminante.setIdBanda(ObjectConversionManager.convert(iterator.next(), Long.class));
			aa17aBandaContaminante.setValorMinimo(ObjectConversionManager.convert(iterator.next(), java.math.BigDecimal.class));
			aa17aBandaContaminante.setValorMaximo(ObjectConversionManager.convert(iterator.next(), java.math.BigDecimal.class));
			aa17aBandaContaminanteList.add(aa17aBandaContaminante);
		}
		this.aa17aBandaContaminanteService.removeMultiple(aa17aBandaContaminanteList);
		Aa17aBandaContaminanteController.logger.info("[POST - DELETE_ALL] : Aa17aBandaContaminante borrados correctamente");
		return aa17aBandaContaminanteIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterAa17aBandaContaminante
	 *            Aa17aBandaContaminante
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(@ModelAttribute Aa17aBandaContaminante filterAa17aBandaContaminante, @ModelAttribute Pagination pagination) {
		List<Aa17aBandaContaminante> aa17aBandaContaminantes = this.aa17aBandaContaminanteService.findAll(filterAa17aBandaContaminante, pagination);
		Long recordNum = this.aa17aBandaContaminanteService.findAllCount(filterAa17aBandaContaminante);
		Aa17aBandaContaminanteController.logger.info("[GET - jqGrid] : Obtener Aa17aBandaContaminante");
		return new JQGridJSONModel(pagination, recordNum, aa17aBandaContaminantes);
	}

	/**
	 * Method 'setAa17aBandaContaminanteService'.
	 * 
	 * @param aa17aBandaContaminanteService
	 *            Aa17aBandaContaminanteService
	 * @return
	 */
	public void setAa17aBandaContaminanteService(Aa17aBandaContaminanteService aa17aBandaContaminanteService) {
		this.aa17aBandaContaminanteService = aa17aBandaContaminanteService;
	}
}
